/*
 * Decompiled with CFR 0.152.
 */
package org.example.API;

import java.math.BigDecimal;
import org.example.API.ApiCalls;
import org.json.JSONArray;

public class CollectData {
    private double Percent = 0.0;
    private int Distance = 0;
    private int SHx = 0;
    private int SHz = 0;
    private int Eyethrows = 0;
    private int Boatstate = 0;
    private int ChunkX = 0;
    private int ChunkZ = 0;
    private boolean Nether = false;
    private double Percent2 = 0.0;
    private int Distance2 = 0;
    private int SHx2 = 0;
    private int SHz2 = 0;
    private int ChunkX2 = 0;
    private int ChunkZ2 = 0;
    private double AngleToCords = 0.0;

    public void UpdateData() {
        ApiCalls BoatAPI = new ApiCalls("/api/v1/boat");
        ApiCalls StrongholdAPI = new ApiCalls("/api/v1/stronghold");
        try {
            BoatAPI.Call();
            StrongholdAPI.Call();
            Object Temp = StrongholdAPI.getData("playerPosition.isInNether");
            this.Nether = Temp instanceof Boolean ? (Boolean)Temp : false;
            Temp = StrongholdAPI.getData("eyeThrows");
            this.Eyethrows = Temp instanceof JSONArray ? ((JSONArray)Temp).length() : 0;
            try {
                double xDiff = Double.parseDouble(StrongholdAPI.getData("predictions.0.chunkX").toString()) * 16.0 + 4.0 - Double.parseDouble(StrongholdAPI.getData("playerPosition.xInOverworld").toString());
                double zDiff = Double.parseDouble(StrongholdAPI.getData("predictions.0.chunkZ").toString()) * 16.0 + 4.0 - Double.parseDouble(StrongholdAPI.getData("playerPosition.zInOverworld").toString());
                double angleToStructure = -Math.atan2(xDiff, zDiff) * 180.0 / Math.PI;
                double angleDifference = (angleToStructure - Double.parseDouble(StrongholdAPI.getData("playerPosition.horizontalAngle").toString())) % 360.0;
                if (angleDifference > 180.0) {
                    angleDifference -= 360.0;
                }
                if (angleDifference < -180.0) {
                    angleDifference += 360.0;
                }
                this.AngleToCords = (double)Math.round(angleDifference * 10.0) / 10.0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Temp = StrongholdAPI.getData("predictions.0.overworldDistance");
            this.Distance = Temp instanceof BigDecimal ? ((BigDecimal)Temp).intValue() : 0;
            Temp = StrongholdAPI.getData("predictions.1.overworldDistance");
            this.Distance2 = Temp instanceof BigDecimal ? ((BigDecimal)Temp).intValue() : 0;
            Temp = StrongholdAPI.getData("predictions.0.chunkX");
            if (Temp instanceof Integer) {
                this.ChunkX = (Integer)Temp;
                this.SHx = this.ChunkX * 16 + 4;
            } else {
                this.ChunkX = 0;
                this.SHx = 0;
            }
            Temp = StrongholdAPI.getData("predictions.1.chunkX");
            if (Temp instanceof Integer) {
                this.ChunkX2 = (Integer)Temp;
                this.SHx2 = this.ChunkX2 * 16 + 4;
            } else {
                this.ChunkX2 = 0;
                this.SHx2 = 0;
            }
            Temp = StrongholdAPI.getData("predictions.0.chunkZ");
            if (Temp instanceof Integer) {
                this.ChunkZ = (Integer)Temp;
                this.SHz = this.ChunkZ * 16 + 4;
            } else {
                this.ChunkZ = 0;
                this.SHz = 0;
            }
            Temp = StrongholdAPI.getData("predictions.1.chunkZ");
            if (Temp instanceof Integer) {
                this.ChunkZ2 = (Integer)Temp;
                this.SHz2 = this.ChunkZ2 * 16 + 4;
            } else {
                this.ChunkZ2 = 0;
                this.SHz2 = 0;
            }
            if (this.Nether) {
                this.Distance /= 8;
                this.Distance2 /= 8;
                this.SHx = this.SHx < 0 ? this.SHx / 8 - 1 : this.SHx / 8;
                this.SHz = this.SHz < 0 ? this.SHz / 8 - 1 : this.SHz / 8;
                this.SHx2 = this.SHx2 < 0 ? this.SHx2 / 8 - 1 : this.SHx2 / 8;
                int n = this.SHz2 = this.SHz2 < 0 ? this.SHz2 / 8 - 1 : this.SHz2 / 8;
            }
            if ((Temp = StrongholdAPI.getData("predictions.0.certainty")) instanceof BigDecimal) {
                this.Percent = ((BigDecimal)Temp).doubleValue();
                this.Percent *= 1000.0;
                this.Percent = Math.round(this.Percent);
                this.Percent /= 10.0;
            } else {
                this.Percent = Temp instanceof Double ? (Double)Temp * 100.0 : (Temp instanceof Integer ? (double)((Integer)Temp * 100) : 0.0);
            }
            Temp = StrongholdAPI.getData("predictions.1.certainty");
            if (Temp instanceof BigDecimal) {
                this.Percent2 = ((BigDecimal)Temp).doubleValue();
                this.Percent2 *= 1000.0;
                this.Percent2 = Math.round(this.Percent2);
                this.Percent2 /= 10.0;
            } else {
                this.Percent2 = Temp instanceof Double ? (Double)Temp * 100.0 : (Temp instanceof Integer ? (double)((Integer)Temp * 100) : 0.0);
            }
            Temp = BoatAPI.getData("boatState");
            if (Temp instanceof String) {
                switch ((String)Temp) {
                    case "NONE": {
                        this.Boatstate = 0;
                        break;
                    }
                    case "MEASURING": {
                        this.Boatstate = 1;
                        break;
                    }
                    case "VALID": {
                        this.Boatstate = 2;
                        break;
                    }
                    case "ERROR": {
                        this.Boatstate = 3;
                        break;
                    }
                    default: {
                        this.Boatstate = 0;
                        break;
                    }
                }
            } else {
                this.Boatstate = 0;
            }
        }
        catch (Exception e) {
            System.err.println("Error updating data: " + e.getMessage());
            e.printStackTrace();
            this.Percent = 0.0;
            this.Distance = 0;
            this.SHx = 0;
            this.SHz = 0;
            this.Eyethrows = 0;
            this.Boatstate = 0;
            this.ChunkX = 0;
            this.ChunkZ = 0;
            this.Nether = false;
            this.Percent2 = 0.0;
            this.Distance2 = 0;
            this.SHx2 = 0;
            this.SHz2 = 0;
            this.ChunkX2 = 0;
            this.ChunkZ2 = 0;
            this.AngleToCords = 0.0;
        }
    }

    public int getDistance() {
        return this.Distance;
    }

    public int getSHx() {
        return this.SHx;
    }

    public int getSHz() {
        return this.SHz;
    }

    public int getEyethrows() {
        return this.Eyethrows;
    }

    public int getBoatstate() {
        return this.Boatstate;
    }

    public int getChunkX() {
        return this.ChunkX;
    }

    public int getChunkZ() {
        return this.ChunkZ;
    }

    public boolean getNether() {
        return this.Nether;
    }

    public double getPercent() {
        return this.Percent;
    }

    public int getChunkZ2() {
        return this.ChunkZ2;
    }

    public int getChunkX2() {
        return this.ChunkX2;
    }

    public int getSHz2() {
        return this.SHz2;
    }

    public int getSHx2() {
        return this.SHx2;
    }

    public int getDistance2() {
        return this.Distance2;
    }

    public double getPercent2() {
        return this.Percent2;
    }

    public double getAngleToCords() {
        return this.AngleToCords;
    }
}

