/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.example.API.CollectData;
import org.example.Main;
import org.json.JSONObject;

public class HTTPServer {
    private static final int PORT = 787;

    public void startWebServer() {
        final CollectData collectData = new CollectData();
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(787), 0);
            System.out.println("Server l\u00e4uft auf Port 787...");
            server.createContext("/api/getData", new HttpHandler(){

                @Override
                public void handle(HttpExchange exchange) throws IOException {
                    HTTPServer.this.setCorsHeaders(exchange);
                    if ("OPTIONS".equals(exchange.getRequestMethod())) {
                        HTTPServer.this.sendCorsResponse(exchange);
                    } else if ("GET".equals(exchange.getRequestMethod())) {
                        HTTPServer.this.sendJsonResponse(exchange, collectData);
                    } else {
                        HTTPServer.this.sendNotFoundResponse(exchange);
                    }
                }
            });
            server.setExecutor(null);
            server.start();
            System.out.println("Webserver gestartet");
        }
        catch (IOException e) {
            System.err.println("Fehler beim Starten des Servers:");
            e.printStackTrace();
        }
    }

    private void setCorsHeaders(HttpExchange exchange) {
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
        exchange.getResponseHeaders().set("Access-Control-Allow-Methods", "GET, OPTIONS");
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", "Content-Type");
        exchange.getResponseHeaders().set("Content-Type", "application/json");
    }

    private void sendCorsResponse(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(204, -1L);
    }

    private void sendJsonResponse(HttpExchange exchange, CollectData collectData) throws IOException {
        JSONObject jsonResponse = new JSONObject();
        try {
            if (Main.TestMode) {
                jsonResponse.put("distance", 1000);
                jsonResponse.put("percent", 25.6);
                jsonResponse.put("isnether", false);
                jsonResponse.put("eyethrows", 3);
                jsonResponse.put("boat", 1);
                jsonResponse.put("x", 12321);
                jsonResponse.put("z", 7871);
            } else if (Main.STATUS) {
                collectData.UpdateData();
                jsonResponse.put("distance", collectData.getDistance());
                jsonResponse.put("percent", collectData.getPercent());
                jsonResponse.put("isnether", collectData.getNether());
                jsonResponse.put("eyethrows", collectData.getEyethrows());
                jsonResponse.put("boat", collectData.getBoatstate());
                jsonResponse.put("x", collectData.getSHx());
                jsonResponse.put("z", collectData.getSHz());
                jsonResponse.put("distance2", collectData.getDistance2());
                jsonResponse.put("percent2", collectData.getPercent2());
                jsonResponse.put("x2", collectData.getSHx2());
                jsonResponse.put("z2", collectData.getSHz2());
                jsonResponse.put("angle", collectData.getAngleToCords());
            } else {
                jsonResponse.put("Ninjabrain", "offline");
            }
            String jsonString = jsonResponse.toString();
            exchange.sendResponseHeaders(200, jsonString.getBytes().length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(jsonString.getBytes());
            }
        }
        catch (Exception e) {
            System.err.println("Fehler beim Abrufen von Daten:");
            e.printStackTrace();
            String errorMessage = "Internal Server Error: " + e.getMessage();
            exchange.sendResponseHeaders(500, errorMessage.getBytes().length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(errorMessage.getBytes());
            }
        }
    }

    private void sendNotFoundResponse(HttpExchange exchange) throws IOException {
        System.out.println("Sende 404 Not Found...");
        String response = "404 Not Found";
        exchange.sendResponseHeaders(404, response.getBytes().length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response.getBytes());
        }
        System.out.println("404 Antwort gesendet.");
    }

    public void stopWebServer() {
        System.out.println("Webserver gestoppt.");
    }

    public void startAsThread() {
        Thread serverThread = new Thread(this::startWebServer);
        serverThread.start();
    }
}

