/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.example.HTTPServer;
import org.example.ServiceTester;

public class Main {
    static boolean STATUS = false;
    static boolean TestMode = false;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Overlay v2.0.0");
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 140);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final JLabel statusLabel = new JLabel("Trying to find Ninjabrain...", 0);
        statusLabel.setFont(new Font("Sans-Serif", 2, 12));
        statusLabel.setForeground(new Color(100, 100, 100));
        mainPanel.add((Component)statusLabel, "North");
        JCheckBox checkBox = new JCheckBox("Test Mode");
        checkBox.setFont(new Font("Sans-Serif", 0, 14));
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TestMode = e.getStateChange() == 1;
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(checkBox);
        final JButton generateButton = new JButton("Generate Browser Source");
        generateButton.setFont(new Font("Arial", 1, 14));
        generateButton.setBackground(new Color(0, 122, 255));
        generateButton.setForeground(Color.WHITE);
        generateButton.setFocusPainted(false);
        generateButton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        generateButton.setContentAreaFilled(false);
        generateButton.setOpaque(true);
        generateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                generateButton.setBackground(new Color(0, 100, 200));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                generateButton.setBackground(new Color(0, 122, 255));
            }
        });
        generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://mcsr-overlay.de/Ninjabrain_Stream_Overlay/editor"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.add(generateButton);
        mainPanel.add((Component)buttonPanel, "Center");
        JLabel NoteLabel = new JLabel("Keep this running while playing!", 0);
        NoteLabel.setFont(new Font("Sans-Serif", 0, 12));
        NoteLabel.setForeground(new Color(100, 100, 100));
        mainPanel.add((Component)NoteLabel, "South");
        frame.add(mainPanel);
        frame.setVisible(true);
        HTTPServer server = new HTTPServer();
        server.startAsThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ServiceTester serviceTester = new ServiceTester();
                boolean nbb = serviceTester.SearchForNinjabrain();
                if (nbb) {
                    statusLabel.setText("Ninjabrain Bot is running!");
                    statusLabel.setFont(new Font("Arial", 1, 12));
                    STATUS = true;
                } else {
                    statusLabel.setText("Trying to find Ninjabrain...");
                    statusLabel.setFont(new Font("Arial", 2, 12));
                    STATUS = false;
                }
            }
        };
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(runnable, 2L, 1L, TimeUnit.SECONDS);
    }
}

